' VB.NET
' Debes usar la siguiente librería: http://www.newtonsoft.com/json
' También puedes usar esta utilería para construir clases para el Json: http://jsonutils.com/

' #########################################################
' #### INTEGRACIÓN FÁCIL ####
' +++++++++++++++++++++++++++++++++++++++++++++++++++++++
' # ESTE CÓDIGO FUNCIONA PARA LA VERSIÓN ONLINE Y OFFLINE
' # Visita www.nubefact.com/integracion para más información
' +++++++++++++++++++++++++++++++++++++++++++++++++++++++

' #########################################################
' #### FORMA DE TRABAJO ####
' +++++++++++++++++++++++++++++++++++++++++++++++++++++++
' # PASO 1: Conseguir una RUTA y un TOKEN para trabajar con NUBEFACT (Regístrate o ingresa a tu cuenta en www.nubefact.com).
' # PASO 2: Generar un archivo en formato .JSON o .TXT con una estructura que se detalla en este documento.
' # PASO 3: Enviar el archivo generado a nuestra WEB SERVICE ONLINE u OFFLINE según corresponda usando la RUTA y el TOKEN.
' # PASO 4: Generamos el archivo XML y PDF (Según especificaciones de la SUNAT) y te devolveremos INSTANTÁNEAMENTE los datos del documento generado.
' # Para ver el documento generado ingresa a www.nubefact.com/login con tus datos de acceso, y luego a la opción "Ver Facturas, Boletas y Notas"
' # IMPORTANTE: Enviaremos el XML generado a la SUNAT y lo almacenaremos junto con el PDF, XML y CDR en la NUBE para que tu cliente pueda consultarlo en cualquier momento, si así lo desea.
' +++++++++++++++++++++++++++++++++++++++++++++++++++++++

' USAR LO SIGUIENTE
Imports System.IO
Imports System.Net
Imports System.Text
Imports Newtonsoft.Json

Namespace IntegracionVisualBasic2

    Public Module NubeFact
        ' #########################################################
        ' #### PASO 1: CONSEGUIR LA RUTA Y TOKEN ####
        ' +++++++++++++++++++++++++++++++++++++++++++++++++++++++
        ' # CUENTA DEMO PARA HACER PRUEBAS
        ' # Puedes usar la siguiente cuenta para hacer pruebas:
        ' #  - LINK: https://demo.nubefact.com/login
        ' #  - USUARIO: demo@nubefact.com
        ' #  - PASSWORD: demo@nubefact.com
        ' # Una vez que ingreses a esta cuenta ve a la opción API (Integración) para ver la RUTA y el TOKEN los cuales son:
        ' #  - RUTA: https://demo.nubefact.com/api/v1/03989d1a-6c8c-4b71-b1cd-7d37001deaa0
        ' #  - TOKEN: d0a80b88cde446d092025465bdb4673e103a0d881ca6479ebbab10664dbc5677
        ' # También puedes crear una cuenta propia para hacer pruebas más precisas.
        ' #
        ' # CREAR UNA CUENTA PROPIA
        ' #  - Regístrate gratis en www.nubefact.com/register
        ' #  - Ir la opción API (Integración).
        ' # IMPORTANTE: Para que la opción API (Integración) de tu cuenta propia esté activada necesitas escribirnos a soporte@nubefact.com o llámanos al teléfono: 01 468 3535 (opción 2) o celular (WhatsApp) 955 598762.
        ' +++++++++++++++++++++++++++++++++++++++++++++++++++++++

        ' # RUTA para enviar documentos
        Dim ruta = "https://demo.nubefact.com/api/v1/03989d1a-6c8c-4b71-b1cd-7d37001deaa0"

        ' # TOKEN para enviar documentos
        Dim token = "d0a80b88cde446d092025465bdb4673e103a0d881ca6479ebbab10664dbc5677"


        Public Sub Main()

            ' #########################################################
            ' #### PASO 2: GENERAR EL ARCHIVO PARA ENVIAR A NUBEFACT ####
            ' +++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ' # - MANUAL para archivo JSON en el link: https://goo.gl/WHMmSb
            ' # - MANUAL para archivo TXT en el link: https://goo.gl/Lz7hAq
            ' +++++++++++++++++++++++++++++++++++++++++++++++++++++++

            ' CREAMOS EL JSON
            Dim invoice = New Invoice()
            invoice.operacion = "generar_comprobante"
            invoice.tipo_de_comprobante = 1
            invoice.serie = "FFF1"
            invoice.numero = 1
            invoice.sunat_transaction = 1
            invoice.cliente_tipo_de_documento = 6
            invoice.cliente_numero_de_documento = "20600695771"
            invoice.cliente_denominacion = "NUBEFACT SA"
            invoice.cliente_direccion = "CALLE LIBERTAD 116 MIRAFLORES - LIMA - PERU"
            invoice.cliente_email = ""
            invoice.cliente_email_1 = ""
            invoice.cliente_email_2 = ""
            invoice.fecha_de_emision = DateTime.Now
            invoice.fecha_de_vencimiento = DateTime.Now.AddDays(3)
            invoice.moneda = 1
            invoice.tipo_de_cambio = ""
            invoice.porcentaje_de_igv = 18.0
            invoice.descuento_global = ""
            invoice.total_descuento = ""
            invoice.total_anticipo = ""
            invoice.total_gravada = 600.0
            invoice.total_inafecta = ""
            invoice.total_exonerada = ""
            invoice.total_igv = 108
            invoice.total_gratuita = ""
            invoice.total_otros_cargos = ""
            invoice.total = 708
            invoice.percepcion_tipo = ""
            invoice.percepcion_base_imponible = ""
            invoice.total_percepcion = ""
            invoice.total_incluido_percepcion = ""
            invoice.detraccion = False
            invoice.observaciones = ""
            invoice.documento_que_se_modifica_tipo = ""
            invoice.documento_que_se_modifica_serie = ""
            invoice.documento_que_se_modifica_numero = ""
            invoice.tipo_de_nota_de_credito = ""
            invoice.tipo_de_nota_de_debito = ""
            invoice.enviar_automaticamente_a_la_sunat = True
            invoice.enviar_automaticamente_al_cliente = False
            invoice.codigo_unico = ""
            invoice.condiciones_de_pago = ""
            invoice.medio_de_pago = ""
            invoice.placa_vehiculo = ""
            invoice.orden_compra_servicio = ""
            invoice.tabla_personalizada_codigo = ""
            invoice.formato_de_pdf = ""
            Dim items() = 'ARRAY DE ITEMS
                {
                New Items With {
                .unidad_de_medida = "NIU",
                .codigo = "001",
                .descripcion = "DETALLE DE PRODUCTO",
                .cantidad = 1,
                .valor_unitario = 500,
                .precio_unitario = 590,
                .descuento = "",
                .subtotal = 500,
                .tipo_de_igv = 1,
                .igv = 90,
                .total = 590,
                .anticipo_regularizacion = False,
                .anticipo_documento_serie = "",
                .anticipo_documento_numero = ""
            },
               New Items With { 'ARRAY DE GUIAS
                .unidad_de_medida = "ZZ",
                .codigo = "001",
                .descripcion = "DETALLE DE SERVICIO",
                .cantidad = 5,
                .valor_unitario = 20,
                .precio_unitario = 23.6,
                .descuento = "",
                .subtotal = 100,
                .tipo_de_igv = 1,
                .igv = 18,
                .total = 118,
                .anticipo_regularizacion = False,
                .anticipo_documento_serie = "",
                .anticipo_documento_numero = ""
            }
            }
            invoice.items = items 'LO ASIGNAMOS A LA PROPIEDAD ITEMS
            Dim json_envio = JsonConvert.SerializeObject(invoice, Formatting.Indented)
            Console.WriteLine(json_envio)
            Dim json_sincodificar = Encoding.UTF8.GetBytes(json_envio)
            Dim json_utf8 = Encoding.UTF8.GetString(json_sincodificar)

            ' #########################################################
            ' #### PASO 3: ENVIAR EL ARCHIVO A NUBEFACT ####
            ' +++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ' # SI ESTÁS TRABAJANDO CON ARCHIVO JSON
            ' # - Debes enviar en el HEADER de tu solicitud la siguiente lo siguiente:
            ' # Authorization = Token token="8d19d8c7c1f6402687720eab85cd57a54f5a7a3fa163476bbcf381ee2b5e0c69"
            ' # Content-Type = application/json
            ' # - Adjuntar en el CUERPO o BODY el archivo JSON o TXT
            ' # SI ESTÁS TRABAJANDO CON ARCHIVO TXT
            ' # - Debes enviar en el HEADER de tu solicitud la siguiente lo siguiente:
            ' # Authorization = Token token="8d19d8c7c1f6402687720eab85cd57a54f5a7a3fa163476bbcf381ee2b5e0c69"
            ' # Content-Type = text/plain
            ' # - Adjuntar en el CUERPO o BODY el archivo JSON o TXT
            ' +++++++++++++++++++++++++++++++++++++++++++++++++++++++

            Dim json_de_respuesta = sendJson(ruta, token, json_utf8)
            Dim r = JsonConvert.DeserializeObject(Of Respuesta)(json_de_respuesta)
            Dim json_r_in = JsonConvert.SerializeObject(r, Formatting.Indented)
            Dim leer_respuesta = JsonConvert.DeserializeObject(Of Respuesta)(json_de_respuesta)

            ' #########################################################
            ' #### PASO 4: LEER RESPUESTA DE NUBEFACT ####
            ' +++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ' # Recibirás una respuesta de NUBEFACT inmediatamente lo cual se debe leer, verificando que no haya errores.
            ' # Debes guardar en la base de datos la respuesta que te devolveremos.
            ' # Escríbenos a soporte@nubefact.com o llámanos al teléfono: 01 468 3535 (opción 2) o celular (WhatsApp) 955 598762
            ' # Puedes imprimir el PDF que nosotros generamos como también generar tu propia representación impresa previa coordinación con nosotros.
            ' # La impresión del documento seguirá haciéndose desde tu sistema. Enviaremos el documento por email a tu cliente si así lo indicas en el archivo JSON o TXT.
            ' +++++++++++++++++++++++++++++++++++++++++++++++++++++++

            If IsNothing(leer_respuesta.errors) Then
                Console.WriteLine()
                Console.WriteLine(json_r_in)
                Console.WriteLine()
                Console.WriteLine()
                Console.WriteLine("TIPO: " & leer_respuesta.tipo_de_comprobante)
                Console.WriteLine("SERIE: " + leer_respuesta.serie)
                Console.WriteLine("NUMERO: " & leer_respuesta.numero)
                Console.WriteLine("URL: " & leer_respuesta.enlace)
                Console.WriteLine("ACEPTADA_POR_SUNAT: " & leer_respuesta.aceptada_por_sunat)
                Console.WriteLine("DESCRIPCION SUNAT: " + leer_respuesta.sunat_description)
                Console.WriteLine("NOTA SUNAT: " & leer_respuesta.sunat_note)
                Console.WriteLine("CODIGO RESPUESTA SUNAT: " & leer_respuesta.sunat_responsecode)
                Console.WriteLine("SUNAT ERROR SOAP: " & leer_respuesta.sunat_soap_error)
                Console.WriteLine("PDF EN BASE64: " & leer_respuesta.pdf_zip_base64)
                Console.WriteLine("XML EN BASE64: " & leer_respuesta.xml_zip_base64)
                Console.WriteLine("CDR EN BASE64: " & leer_respuesta.cdr_zip_base64)
                Console.WriteLine("CODIGO QR: " + leer_respuesta.cadena_para_codigo_qr)
                Console.WriteLine("CODIGO HASH: " & leer_respuesta.codigo_hash)
                Console.WriteLine("CODIGO DE BARRAS: " & leer_respuesta.codigo_de_barras) 'SOLO SE PUEDE CONCATENAR CON + EN VARIABLES DEL MISMO TIPO USAR & ALTERNATIVAMENTE
                Console.ReadKey()
            Else
                Console.WriteLine("ERROR: " & leer_respuesta.errors)
                Console.ReadKey()
            End If
        End Sub

        Function sendJson(ruta As String, token As String, json As String) As String
            Using wc As New WebClient
                Try
                    wc.Headers.Add(HttpRequestHeader.ContentType, "application/json; charset=utf-8")
                    wc.Headers.Add(HttpRequestHeader.Authorization, "Token token=" & token)
                    Dim respuesta = wc.UploadString(ruta, "POST", json)
                    Return respuesta
                Catch x As WebException
                    Return New StreamReader(x.Response.GetResponseStream).ReadToEnd
                End Try
            End Using
        End Function

    End Module


    ' CREAMOS LAS CLASES PARA CONSTRUIR EL JSON Y LEER LA RESPUESTA EN JSON
    Public Class Invoice
        Public Property operacion As String
        Public Property tipo_de_comprobante As Integer
        Public Property serie As String
        Public Property numero As Integer
        Public Property sunat_transaction As Integer
        Public Property cliente_tipo_de_documento As Integer
        Public Property cliente_numero_de_documento As String
        Public Property cliente_denominacion As String
        Public Property cliente_direccion As String
        Public Property cliente_email As String
        Public Property cliente_email_1 As String
        Public Property cliente_email_2 As String
        Public Property fecha_de_emision As DateTime
        Public Property fecha_de_vencimiento
        Public Property moneda As Integer
        Public Property tipo_de_cambio '? MAKES NATURAL TYPES NULLABLE
        Public Property porcentaje_de_igv As Double
        Public Property descuento_global
        Public Property total_descuento
        Public Property total_anticipo
        Public Property total_gravada
        Public Property total_inafecta
        Public Property total_exonerada
        Public Property total_igv
        Public Property total_gratuita
        Public Property total_otros_cargos
        Public Property total As Double
        Public Property percepcion_tipo
        Public Property percepcion_base_imponible
        Public Property total_percepcion
        Public Property total_incluido_percepcion
        Public Property detraccion As Boolean
        Public Property observaciones As String
        Public Property documento_que_se_modifica_tipo
        Public Property documento_que_se_modifica_serie As String
        Public Property documento_que_se_modifica_numero
        Public Property tipo_de_nota_de_credito
        Public Property tipo_de_nota_de_debito
        Public Property enviar_automaticamente_a_la_sunat As Boolean
        Public Property enviar_automaticamente_al_cliente As Boolean
        Public Property codigo_unico As String
        Public Property condiciones_de_pago As String
        Public Property medio_de_pago As String
        Public Property placa_vehiculo As String
        Public Property orden_compra_servicio As String
        Public Property tabla_personalizada_codigo As String
        Public Property formato_de_pdf As String
        Public Property items() As Items()
        Public Property guias() As Guias()
    End Class

    Public Class Items
        Public Property unidad_de_medida As String
        Public Property codigo As String
        Public Property descripcion As String
        Public Property cantidad As Double
        Public Property valor_unitario As Double
        Public Property precio_unitario As Double
        Public Property descuento
        Public Property subtotal As Double
        Public Property tipo_de_igv As Integer
        Public Property igv As Double
        Public Property total As Double
        Public Property anticipo_regularizacion As Boolean
        Public Property anticipo_documento_serie
        Public Property anticipo_documento_numero
    End Class

    Public Class Guias
        Public guia_tipo As Integer
        Public guia_serie_numero As String
    End Class

    Public Class Respuesta
        Public Property errors As String
        Public Property tipo_de_comprobante As Integer
        Public Property serie As String
        Public Property numero As Integer
        Public Property enlace As String
        Public Property aceptada_por_sunat As Boolean
        Public Property sunat_description As String
        Public Property sunat_note As String
        Public Property sunat_responsecode As String
        Public Property sunat_soap_error As String
        Public Property pdf_zip_base64 As String
        Public Property xml_zip_base64 As String
        Public Property cdr_zip_base64 As String
        Public Property cadena_para_codigo_qr As String
        Public Property codigo_hash As String
        Public Property codigo_de_barras As String
    End Class
End Namespace